/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import com.tiviacz.pizzacraft.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicPizzaSliceModel
implements IUnbakedGeometry<DynamicPizzaSliceModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    private static final Transformation FLUID_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.002f), Quaternion.f_80118_);
    private static final Transformation COVER_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.004f), Quaternion.f_80118_);
    @Nonnull
    private final ItemStack stack;

    public DynamicPizzaSliceModel(ItemStack stack) {
        this.stack = stack;
    }

    public DynamicPizzaSliceModel withStack(ItemStack stack) {
        return new DynamicPizzaSliceModel(stack);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation rootTransform;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.hasMaterial("particle") ? owner.getMaterial("particle") : null;
        Material baseLocation = owner.hasMaterial("base") ? owner.getMaterial("base") : null;
        ArrayList<Material> layersLocations = new ArrayList<Material>();
        ItemStackHandler handler = Utils.createHandlerFromStack(this.stack, 9);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackInSlot = handler.getStackInSlot(i);
            List tags = stackInSlot.m_204131_().toList();
            for (TagKey tag : tags) {
                if (!PizzaLayers.VALID_ITEM_TAGS.contains(tag)) continue;
                layersLocations.add(new Material(InventoryMenu.f_39692_, PizzaLayers.getTagToItemLayer().get(tag)));
            }
        }
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = spriteGetter.apply(baseLocation);
        }
        if (!(rootTransform = owner.getRootTransform()).isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)owner).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new PizzaSliceOverrideHandler(overrides, bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)owner.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicPizzaSliceModel.getLayerRenderTypes();
        if (baseLocation != null) {
            TextureAtlasSprite sprite = spriteGetter.apply(baseLocation);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            builder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (!layersLocations.isEmpty()) {
            int i = 0;
            for (Material material : layersLocations) {
                TextureAtlasSprite sprite = spriteGetter.apply(material);
                ++i;
                if (sprite == null) continue;
                SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(DynamicPizzaSliceModel.getLayerTransformation(i)), modelState.m_7538_());
                List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)sprite);
                List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
                builder.addQuads(DynamicPizzaSliceModel.getLayerRenderTypes(), (Collection)quads);
            }
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public static Transformation getLayerTransformation(int i) {
        return new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.004f + (float)i * 4.0E-4f), Quaternion.f_80118_);
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.hasMaterial("particle")) {
            texs.add(owner.getMaterial("particle"));
        }
        if (owner.hasMaterial("base")) {
            texs.add(owner.getMaterial("base"));
        }
        return texs;
    }

    private static final class PizzaSliceOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IGeometryBakingContext owner;
        private final DynamicPizzaSliceModel parent;

        private PizzaSliceOverrideHandler(ItemOverrides nested, ModelBakery bakery, IGeometryBakingContext owner, DynamicPizzaSliceModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int integer) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, level, entity, integer);
            if (overriden != originalModel) {
                return overriden;
            }
            if (stack.m_41783_() != null) {
                String name = stack.m_41783_().m_128469_("Inventory").toString();
                if (!this.cache.containsKey(name)) {
                    DynamicPizzaSliceModel unbaked = this.parent.withStack(stack);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("pizzacraft:pizza_slice_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }
            return originalModel;
        }
    }

    public static enum Loader implements IGeometryLoader<DynamicPizzaSliceModel>
    {
        INSTANCE;


        public DynamicPizzaSliceModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new DynamicPizzaSliceModel(ItemStack.f_41583_);
        }
    }
}

